Rem lastopc.sql
Rem
Rem Copyright (c) 2008, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
SET SERVEROUTPUT ON

SELECT TO_CHAR (SYSDATE, 'MM-DD-YYYY HH24:MI:SS') "NOW" FROM DUAL;

drop table base;

begin
  for t in (select table_name from user_tables where table_name like 'INPTAB%') loop
    execute immediate 'drop table ' || t.table_name;
  end loop;
end;
/
show errors;

begin
  for t in (select table_name from user_tables where table_name like 'BLKTAB%') loop
    execute immediate 'drop table ' || t.table_name;
  end loop;
end;
/
show errors;

begin
  for t in (select table_name from user_tables where table_name like 'RES%') loop
    execute immediate 'drop table ' || t.table_name;
  end loop;
end;
/
show errors;

DECLARE
increment number := 1;
limit number;
pc sdo_pc;
stmt varchar2(3000);
inptabname varchar2(100);
blktabname varchar2(100);
resname varchar2(100);

BEGIN
  -- Create 'base' (final, permanent) table containing pointcloud column.
  stmt := 'create table base(
                  pc sdo_pc,
                  id number,
                  source_file_name varchar(1024),
		  coverage_geometry sdo_geometry,
		  file_signature varchar(4),
		  reserved number,
		  guid_data_1 number,
		  guid_data_2 number,
		  guid_data_3 number,
		  guid_data_4 varchar2(8),
		  version_major number,
		  version_minor number,
		  system_identifier varchar2(32),
		  generating_software varchar2(32),
		  flight_julian_date number,
		  year number,
		  header_size number,
		  offset_to_data number,
		  number_variable_length_records number,
		  point_data_format_id number,
		  point_data_record_length number,
		  number_of_point_records number,
		  number_of_points_by_return_1 number,
		  number_of_points_by_return_2 number,
		  number_of_points_by_return_3 number,
		  number_of_points_by_return_4 number,
		  number_of_points_by_return_5 number,
		  x_scale_factor number,
		  y_scale_factor number,
		  z_scale_factor number,
		  x_offset number,
		  y_offset number,
		  z_offset number,
		  max_x number,
		  min_x number,
		  max_y number,
		  min_y number,
		  max_z number,
		  min_z number) nologging';
  execute immediate stmt;

  select count(*) into limit from lidar_data;
  for lidar_id in 1 .. limit loop
    inptabname := 'INPTAB' || TO_CHAR(lidar_id);
    blktabname := 'BLKTAB' || TO_CHAR(lidar_id);
    resname    := 'RES'    || TO_CHAR(lidar_id);
    
    -- INPTAB contains the input data for the PointCloud.-> try view here! more efficient!
    -- This is the input table. 
    -- The input table is always of the form
    -- rid varchar2(24), val_d1, val_d2,... val_dn numbers
    -- where "n" is the total_dimensionality of the PointCloud.
    stmt := 'CREATE TABLE ' || inptabname || ' NOLOGGING AS
     SELECT TO_CHAR(a.pdr_id)                   rid,
            a.point_geometry.sdo_point.x val_d1,
            a.point_geometry.sdo_point.y val_d2,
            a.point_geometry.sdo_point.z val_d3
     FROM point_data_records a where a.fk_id = ' || 
     TO_CHAR(lidar_id);
     --FROM TABLE(select point_data_records from lidar_data where id = ' || 
     --TO_CHAR(lidar_id) || ') a';
    EXECUTE IMMEDIATE stmt;
    
    -- Create block tables to store the blocks of each pointcloud. 
    -- Block table is always created as select * from mdsys.sdo_pc_blk_table per pointcloud.
    -- Thus, there must be block tables as many as LAS files.
    stmt := 'create table ' || blktabname || 
            ' nologging as select * from mdsys.sdo_pc_blk_table';
    EXECUTE IMMEDIATE stmt;

    -- This is the result table .
    -- This table should have the same attributes as INPTAB
    -- but with two additional columns ptn_id and point_id. 
    stmt := 'create table ' || resname || 
            ' (ptn_id number, point_id number, 
              rid varchar2(24), val_d1 number, val_d2 number, val_d3 number) nologging';
    EXECUTE IMMEDIATE stmt;

    stmt := 'truncate table ' || resname;
    EXECUTE IMMEDIATE stmt;
    stmt := 'truncate table ' || blktabname;
    EXECUTE IMMEDIATE stmt;

    -- Initialize a PointCloud object and populate it using the points in INPTAB.
    -- Initialize the Point Cloud object. 
    pc := sdo_pc_pkg.init(
          'BASE', -- Table that has the SDO_POINT_CLOUD column defined
          'PC',   -- Column name of the SDO_POINT_CLOUD object 
          blktabname, -- Table to store blocks of the point cloud
           'blk_capacity=10000', -- max # of points per block 
           mdsys.sdo_geometry(2003, 8307, null,
              mdsys.sdo_elem_info_array(1,1003,3),
              mdsys.sdo_ordinate_array(-180, -90, 180, 90)),  -- Extent 
           0.5, -- Tolerance for point cloud
           3, -- Total number of dimensions
           null);

    -- Insert the Point Cloud object  into the "base" table.
    execute immediate 'insert /*+append*/ into base(pc) values (:1)' using pc;
    commit;
    stmt := 'insert /*+append*/ into base(
                  id,
                  source_file_name,
                  coverage_geometry,
                  file_signature,
                  reserved,
                  guid_data_1,
                  guid_data_2,
                  guid_data_3,
                  guid_data_4,
                  version_major,
                  version_minor,
                  system_identifier,
                  generating_software,
                  flight_julian_date,
                  year,
                  header_size,
                  offset_to_data,
                  number_variable_length_records,
                  point_data_format_id,
                  point_data_record_length,
                  number_of_point_records,
                  number_of_points_by_return_1,
                  number_of_points_by_return_2,
                  number_of_points_by_return_3,
                  number_of_points_by_return_4,
                  number_of_points_by_return_5,
                  x_scale_factor,
                  y_scale_factor,
                  z_scale_factor,
                  x_offset,
                  y_offset,
                  z_offset,
                  max_x,
                  min_x,
                  max_y,
                  min_y,
                  max_z,
                  min_z) 
             select 
                  id,
                  source_file_name,
                  coverage_geometry,
                  file_signature,
                  reserved,
                  guid_data_1,
                  guid_data_2,
                  guid_data_3,
                  guid_data_4,
                  version_major,
                  version_minor,
                  system_identifier,
                  generating_software,
                  flight_julian_date,
                  year,
                  header_size,
                  offset_to_data,
                  number_variable_length_records,
                  point_data_format_id,
                  point_data_record_length,
                  number_of_point_records,
                  number_of_points_by_return_1,
                  number_of_points_by_return_2,
                  number_of_points_by_return_3,
                  number_of_points_by_return_4,
                  number_of_points_by_return_5,
                  x_scale_factor,
                  y_scale_factor,
                  z_scale_factor,
                  x_offset,
                  y_offset,
                  z_offset,
                  max_x,
                  min_x,
                  max_y,
                  min_y,
                  max_z,
                  min_z from lidar_data where id = ' || 
                  TO_CHAR(lidar_id);
    execute immediate stmt;
    commit;

    -- Create the blocks for the point cloud.
    sdo_pc_pkg.create_pc(
      pc,         -- Initialized PointCloud object
      inptabname, -- Name of input table to ingest into the pointcloud
      resname     -- Name of output table that stores the points (with ptn_id,pt_id)
    );
    -- Point Cloud is created.

    dbms_output.put_line(lidar_id);
    -- Cleanup
    -- PointCloud may not be created if there are scratch tables from previous run
    -- of an aborted creation. A subsequent Point Cloud creation using
    -- above script may result in the following errors.
    -- "ORA-13199: Rerun after cleaning up using sdo_util.drop_work_tables('F337')
    --  ORA-54605: CREATE_PC: scratch tables/views(M%_1_F337$$%) exist ..."
    -- The following actions need to be performed based on these error messages.
    -- SQL> exec sdo_util.drop_work_tables('F337');
    -- The 54605 error msg also contains the pcid as M%_<pcid>_F337$$%,
    -- i.e., pcid=1. One can delete the PC from base table where pc_id=<pcid>.
    -- SQL> delete from base a where a.pc_id=1;
    -- SQL> commit;
    -- The above creation script can then be rerun for successful creation.
    stmt := 'drop table ' || inptabname;
    EXECUTE IMMEDIATE stmt;
  END LOOP;
END;
/
show errors; 

COMMIT;
SELECT TO_CHAR (SYSDATE, 'MM-DD-YYYY HH24:MI:SS') "NOW" FROM DUAL;

delete from user_sdo_geom_metadata where table_name = 'LIDAR_DATA';
delete from user_sdo_geom_metadata where table_name = 'PDRT_LIDAR_DATA';
drop sequence s_lidar_data;
drop table lidar_data;
show errors;
exit;
